Opt("TrayIconDebug",1)
Func _ArrayAdd(ByRef $avArray, $vValue)
If Not IsArray($avArray) Then Return SetError(1, 0, -1)
If UBound($avArray, 0) <> 1 Then Return SetError(2, 0, -1)
Local $iUBound = UBound($avArray)
ReDim $avArray[$iUBound + 1]
$avArray[$iUBound] = $vValue
Return $iUBound
EndFunc
Func _ArrayDelete(ByRef $avArray, $iElement)
If Not IsArray($avArray) Then Return SetError(1, 0, 0)
Local $iUBound = UBound($avArray, 1) - 1
If Not $iUBound Then
$avArray = ""
Return 0
EndIf
If $iElement < 0 Then $iElement = 0
If $iElement > $iUBound Then $iElement = $iUBound
Switch UBound($avArray, 0)
Case 1
For $i = $iElement To $iUBound - 1
$avArray[$i] = $avArray[$i + 1]
Next
ReDim $avArray[$iUBound]
Case 2
Local $iSubMax = UBound($avArray, 2) - 1
For $i = $iElement To $iUBound - 1
For $j = 0 To $iSubMax
$avArray[$i][$j] = $avArray[$i + 1][$j]
Next
Next
ReDim $avArray[$iUBound][$iSubMax + 1]
Case Else
Return SetError(3, 0, 0)
EndSwitch
Return $iUBound
EndFunc
Global Const $tagPOINT = "long X;long Y"
Func _WinAPI_GetLastError($curErr=@error, $curExt=@extended)
Local $aResult = DllCall("kernel32.dll", "dword", "GetLastError")
Return SetError($curErr, $curExt, $aResult[0])
EndFunc
Global Const $__WINAPICONSTANT_FORMAT_MESSAGE_ALLOCATE_BUFFER = 0x100
Global Const $__WINAPICONSTANT_FORMAT_MESSAGE_FROM_SYSTEM = 0x1000
Global Const $HGDI_ERROR = Ptr(-1)
Global Const $INVALID_HANDLE_VALUE = Ptr(-1)
Global Const $KF_EXTENDED = 0x0100
Global Const $KF_ALTDOWN = 0x2000
Global Const $KF_UP = 0x8000
Global Const $LLKHF_EXTENDED = BitShift($KF_EXTENDED, 8)
Global Const $LLKHF_ALTDOWN = BitShift($KF_ALTDOWN, 8)
Global Const $LLKHF_UP = BitShift($KF_UP, 8)
Func _WinAPI_FormatMessage($iFlags, $pSource, $iMessageID, $iLanguageID, ByRef $pBuffer, $iSize, $vArguments)
Local $sBufferType = "ptr"
If IsString($pBuffer) Then $sBufferType = "wstr"
Local $aResult = DllCall("Kernel32.dll", "dword", "FormatMessageW", "dword", $iFlags, "ptr", $pSource, "dword", $iMessageID, "dword", $iLanguageID, _
$sBufferType, $pBuffer, "dword", $iSize, "ptr", $vArguments)
If @error Then Return SetError(@error, @extended, 0)
If $sBufferType = "wstr" Then $pBuffer = $aResult[5]
Return $aResult[0]
EndFunc
Func _WinAPI_GetLastErrorMessage()
Local $tBufferPtr = DllStructCreate("ptr")
Local $pBufferPtr = DllStructGetPtr($tBufferPtr)
Local $nCount = _WinAPI_FormatMessage(BitOR($__WINAPICONSTANT_FORMAT_MESSAGE_ALLOCATE_BUFFER, $__WINAPICONSTANT_FORMAT_MESSAGE_FROM_SYSTEM), _
0, _WinAPI_GetLastError(), 0, $pBufferPtr, 0, 0)
If @error Then Return SetError(@error, 0, "")
Local $sText = ""
Local $pBuffer = DllStructGetData($tBufferPtr, 1)
If $pBuffer Then
If $nCount > 0 Then
Local $tBuffer = DllStructCreate("wchar[" &($nCount+1) & "]", $pBuffer)
$sText = DllStructGetData($tBuffer, 1)
EndIf
_WinAPI_LocalFree($pBuffer)
EndIf
Return $sText
EndFunc
Func _WinAPI_LocalFree($hMem)
Local $aResult = DllCall("kernel32.dll", "handle", "LocalFree", "handle", $hMem)
If @error Then Return SetError(@error, @extended, False)
Return $aResult[0]
EndFunc
Global $path, $title, $parameters, $Directory
If StringInStr(@Scriptname,"D2Multi.exe") Then
$path = StringStripWs(Iniread(@Scriptdir & "\D2Multi.ini","Settings","D2Folder ",False),1)
Else
$path = StringStripWs(Iniread(@Scriptdir & "\D2Extra.ini","CONFIG","D2Folder ",False),1)
EndIf
If NOT $path then
MsgBox(16,"D2Extra","Please type in a path in settings...")
Exit
EndIf
$Directory = $path
$path &= "\Game.exe"
If NOT FileExists($path) Then
MsgBox(16,"D2Extra","Please type in an existing path in settings..." & @CRLF & " -> " & $path)
Exit
EndIf
$title = False
Global $MyCmdline = $cmdline
For $i = 1 to $MyCmdline[0]
If StringInStr($MyCmdline[$i],"-title") Then
$title = $MyCmdline[$i+1]
_ArrayDelete($MyCmdline,$i)
_ArrayDelete($MyCmdline,$i)
$MyCmdline[0] -= 2
ExitLoop
EndIf
Next
If NOT $title Then $title = StringStripWs(Iniread(@Scriptdir & "\D2Extra.ini","CONFIG","Title ","Diablo II"),1)
Global $parameters = StringStripWs(Iniread(@Scriptdir & "\D2Extra.ini","CONFIG","Parameters ","-w"),1)
Global $DiabloIdentifer = StringStripWs(Iniread(@Scriptdir & "\D2Extra.ini","CONFIG","Identifier ","Diablo II"),1)
Global $list
Global $HDias = GUICreate("Diablo II secret area")
$list = Winlist($DiabloIdentifer)
If $list[0][0] > 0 Then
Global $DiabloList[$list[0][0]+1]
$DiabloList[0] = $list[0][0]
For $i = 1 to $list[0][0]
$DiabloList[$i] = $list[$i][1]
Next
Else
Global $DiabloList[1] = [0]
EndIf
If NOT _DiaAPI_CreateDia($path,$title,$parameters,$Directory) Then MsgBox(16,"D2Extra","Something went wrong...")
Func _DiaAPI_CreateDia($sPath, $sTitle = "Diablo II", $Params = "",$Workingdirectory = @ScriptDir,$iLeft = "", $iTop = "", $iWidth = "", $iHeight = "")
For $i = 1 To $DiabloList[0]
If IsHwnd($DiabloList[$i]) Then
If NOT _ChangeParent($DiabloList[$i], $HDias) Then MsgBox(16,"D2Extra","Error code while changing parent: " & _WinAPI_GetLastError() & @CRLF & _WinAPI_GetLastErrorMessage())
EndIf
Next
If $sPath <> "" Then
$sPath &= " " & $Params
ConsoleWrite($sPath)
If NOT Run($sPath,$Workingdirectory) Then
MsgBox(16,"D2Extra","Failed to run path")
Return False
EndIf
$hWnd = WinWait($DiabloIdentifer)
_ArrayAdd($DiabloList, $hWnd)
$DiabloList[0] += 1
WinSetTitle($hWnd, "", $sTitle)
$xywh = WinGetPos($hWnd)
If Not @error Then
If $iLeft = "" Then $iLeft = $xywh[0]
If $iTop = "" Then $iTop = $xywh[1]
If $iWidth = "" Then $iWidth = $xywh[2]
If $iHeight = "" Then $iHeight = $xywh[3]
EndIf
WinMove($hWnd, "", $iLeft, $iTop, $iWidth, $iHeight)
Else
Return False
EndIf
For $i = 1 To $DiabloList[0]
If IsHwnd($DiabloList[$i]) Then
If NOT _ChangeParent($DiabloList[$i], 0) Then MsgBox(16,"D2Extra","Error code while changing parent: " & _WinAPI_GetLastError() & @CRLF & _WinAPI_GetLastErrorMessage())
EndIf
Next
Return $hWnd
EndFunc
Func _ChangeParent($hWndChild, $hWndParentNew)
$Call = DllCall('user32.dll', 'hWnd', 'SetParent', 'hWnd', $hWndChild, 'hWnd', $hWndParentNew)
Return $Call[0]
EndFunc
